/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acmx.export.javax.swing.AWTCheckBox;
import acmx.export.javax.swing.CheckBoxListener;
import acmx.export.javax.swing.JCheckBoxModel;
import acmx.export.javax.swing.SwingInteractor;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;

public class JCheckBox
extends SwingInteractor
implements ItemSelectable {
    private ArrayList<ActionListener> actionListeners;
    private ArrayList<ItemListener> itemListeners;
    private JCheckBoxModel model = new AWTCheckBox();
    private CheckBoxListener checkBoxListener;

    public JCheckBox() {
        this("");
    }

    public JCheckBox(String name) {
        this(name, false);
    }

    public JCheckBox(String name, boolean state) {
        this.setContents((Component)((Object)this.model));
        this.setText(name);
        this.actionListeners = new ArrayList();
        this.itemListeners = new ArrayList();
        this.checkBoxListener = new CheckBoxListener(this);
        this.model.addActionListener(this.checkBoxListener);
        this.model.setSelected(state);
    }

    public void setText(String text) {
        this.model.setText(text);
    }

    public String getText() {
        return this.model.getText();
    }

    public void setActionCommand(String command) {
        this.model.setActionCommand(command);
    }

    public String getActionCommand() {
        String cmd = this.model.getActionCommand();
        if (cmd == null) {
            cmd = this.model.getText();
        }
        return cmd;
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    protected void fireActionListeners(ActionEvent e) {
        int nListeners = this.actionListeners.size();
        int i = 0;
        while (i < nListeners) {
            this.actionListeners.get(i).actionPerformed(e);
            ++i;
        }
    }

    public void addItemListener(ItemListener listener) {
        this.itemListeners.add(listener);
    }

    public void removeItemListener(ItemListener listener) {
        this.itemListeners.remove(listener);
    }

    protected void fireItemListeners(ItemEvent e) {
        int nListeners = this.itemListeners.size();
        int i = 0;
        while (i < nListeners) {
            this.itemListeners.get(i).itemStateChanged(e);
            ++i;
        }
    }

    public boolean isSelected() {
        return this.model.isSelected();
    }

    public void setSelected(boolean state) {
        this.model.setSelected(state);
    }

    public Object[] getSelectedObjects() {
        if (this.model.isSelected()) {
            Object[] items = new Object[]{this};
            return items;
        }
        return null;
    }

    public ActionListener[] getActionListeners() {
        int nListeners = this.actionListeners.size();
        ActionListener[] array = new ActionListener[nListeners];
        int i = 0;
        while (i < nListeners) {
            array[i] = this.actionListeners.get(i);
            ++i;
        }
        return array;
    }
}

